/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.netdiag;

import com.ibm.hwmca.base.netdiag.NetDiagRequests;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;

public class NetDiagInfoBean
extends PanelBean
implements TaskActionListener,
NetDiagRequests {
    private ItemDescriptor[] m_idInfoTable;
    private ColumnDescriptor[] m_cdInfoTableStructure;
    private int[] m_iInfoTableSelection;
    private String m_sSearchEdit;
    private String m_sTcpIpEdit;
    private ItemDescriptor[] m_idPingTable;
    private ColumnDescriptor[] m_cdPingTableStructure;
    private int[] m_iPingTableSelection;
    private String[] displayedText;
    private boolean showNativeConnectionsPanel = true;
    private static final String ACTIVATED = "ACTIVATED";
    private static final String INFO_TABLE_NAME = "InfoTable";
    private static final String PING_TABLE_NAME = "PingTable";
    private static final String SELECTED_TEXT_NAME = "InfoChoice";
    private static final String CANCEL_BUTTON_NAME = "CancelButton";
    private static final String SEARCH_BUTTON_NAME = "SearchButton";
    private static final String REFRESH_BUTTON_NAME = "RefreshButton";
    private static final String SEARCH_ENTRY_FIELD_NAME = "SearchEdit";
    private static final String PING_ENTRY_FIELD_NAME = "TcpIpEdit";
    private static final String PING_BUTTON_NAME = "PingButton";
    private static final String PING_PANEL_NAME = "PingPanel";
    private String tabPanelName = "PingPanel";
    private static final String TRACE_MASKT = "HNTDB CT";
    private static final String TRACE_MASKF = "HNTDB CF";
    private static final String TRACE_MASKD = "HNTDB CD";

    private void setDisplayedText(String[] text) {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.setDisplayedText(), text is " + text);
        this.m_iInfoTableSelection = new int[0];
        this.displayedText = text;
    }

    private String[] getDisplayedText() {
        return this.displayedText;
    }

    private ItemDescriptor[] getTable() {
        return this.tabPanelName.equals(PING_PANEL_NAME) ? this.m_idPingTable : this.m_idInfoTable;
    }

    private void setTableSelection(int index) {
        Trace.trace(TRACE_MASKD, "   setting the selected row to " + index);
        if (this.tabPanelName.equals(PING_PANEL_NAME)) {
            this.m_iPingTableSelection = new int[1];
            this.m_iPingTableSelection[0] = index;
        } else {
            this.m_iInfoTableSelection = new int[1];
            this.m_iInfoTableSelection[0] = index;
        }
    }

    private int[] getTableSelections() {
        return this.tabPanelName.equals(PING_PANEL_NAME) ? this.m_iPingTableSelection : this.m_iInfoTableSelection;
    }

    private String getTableName() {
        return this.tabPanelName.equals(PING_PANEL_NAME) ? this.tabPanelName + "." + PING_TABLE_NAME : this.tabPanelName + "." + INFO_TABLE_NAME;
    }

    private void search(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> NetDiagInfoBean.search()");
        ItemDescriptor[] table = this.getTable();
        if (table != null && table.length > 0) {
            utm.storeElement(this.tabPanelName + "." + SEARCH_ENTRY_FIELD_NAME);
            if (this.m_sSearchEdit.length() > 0) {
                String elementName = this.getTableName();
                int[] row = utm.getSelectedRows(elementName);
                int index = 0;
                if (row.length > 0) {
                    index = row[0] + 1;
                    Trace.trace(TRACE_MASKD, "   row " + row[0] + " is currently selected");
                } else {
                    Trace.trace(TRACE_MASKD, "   nothing is currently selected");
                }
                String searchText = this.m_sSearchEdit.toUpperCase();
                int[] newSelection = new int[1];
                for (int i = index; i < table.length; ++i) {
                    String title = table[i].getTitle().toUpperCase();
                    if (title.indexOf(searchText) < 0) continue;
                    this.setTableSelection(i);
                    utm.refreshElement(elementName);
                    break;
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- NetDiagInfoBean.search()");
    }

    private void updateTable(String tabPanelName) {
        Trace.trace(TRACE_MASKF, "-> NetDiagInfoBean.updateTable()");
        if (this.displayedText != null) {
            ItemDescriptor[] table;
            Trace.trace(TRACE_MASKF, "   number of lines to display is " + this.displayedText.length);
            if (tabPanelName.equals(PING_PANEL_NAME)) {
                table = this.m_idPingTable = new ItemDescriptor[this.displayedText.length];
            } else {
                this.m_idInfoTable = new ItemDescriptor[this.displayedText.length];
                table = this.m_idInfoTable;
            }
            for (int i = 0; i < this.displayedText.length; ++i) {
                table[i] = new ItemDescriptor(tabPanelName + String.valueOf(i), this.displayedText[i]);
                Trace.trace(TRACE_MASKD, "   table[" + i + "] is " + table[i].getTitle());
            }
        }
        Trace.trace(TRACE_MASKF, "<- NetDiagInfoBean.updateTable()");
    }

    private void tabPressed(String tabPanelName) {
        Trace.trace(TRACE_MASKF, "-> NetDiagInfoBean.tabPressed()");
        this.m_iInfoTableSelection = new int[0];
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setData("Request", tabPanelName);
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKF, "<- NetDiagInfoBean.tabPressed()");
    }

    private void ping(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> NetDiagInfoBean.ping()");
        try {
            this.m_iPingTableSelection = new int[0];
            String elementName = "PingPanel.TcpIpEdit";
            Trace.trace(TRACE_MASKF, "   tell UTM to store element " + elementName);
            utm.storeElement(elementName);
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Request", PING_PANEL_NAME);
            request.setData("IpAddress", this.getTcpIpEdit());
            this.postTaskletRequest(request);
        }
        catch (IllegalUserDataException exc) {
            Trace.trace(TRACE_MASKT, "   caught exc " + (Object)((Object)exc));
            exc.printStackTrace();
        }
        Trace.trace(TRACE_MASKF, "<- NetDiagInfoBean.ping()");
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKF, "-> update()");
        Trace.trace(TRACE_MASKF, "  UTM is " + this.getUserTaskManager());
        Trace.trace(TRACE_MASKF, "  this is " + this);
        UserTaskManager utm = this.getUserTaskManager();
        String[] data = (String[])object;
        this.setDisplayedText(data);
        this.updateTable(this.tabPanelName);
        String elementName = this.getTableName();
        Trace.trace(TRACE_MASKF, "  tell UTM to refresh element " + elementName);
        utm.refreshElement(elementName);
        Trace.trace(TRACE_MASKF, "<- update()");
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> NetDiagInfoBean.panelAction()");
        Trace.trace(TRACE_MASKF, "   event is " + evt);
        Trace.trace(TRACE_MASKF, "   action command is " + evt.getActionCommand());
        Trace.trace(TRACE_MASKF, "   this is " + this);
        String elementName = evt.getElementName();
        Trace.trace(TRACE_MASKF, "   element name is [" + elementName + "]");
        if (elementName.equals(CANCEL_BUTTON_NAME)) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Request", "Request");
            Trace.trace(TRACE_MASKF, "   before postTaskletRequest");
            this.postTaskletRequest(request);
        } else {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            Trace.trace(TRACE_MASKF, "   UTM is " + utm);
            NetDiagInfoBean realBean = (NetDiagInfoBean)utm.getDataObjects()[0];
            if (this != realBean) {
                realBean.panelAction(evt);
            } else {
                String actionCommand = evt.getActionCommand();
                if (actionCommand != null && actionCommand.equals(ACTIVATED)) {
                    this.tabPanelName = elementName;
                    Trace.trace(TRACE_MASKF, "   tab selected, name is " + this.tabPanelName);
                    if (!this.tabPanelName.equals(PING_PANEL_NAME)) {
                        this.tabPressed(elementName);
                    }
                } else if (elementName.indexOf(SEARCH_BUTTON_NAME) >= 0) {
                    this.search(utm);
                } else if (elementName.indexOf(REFRESH_BUTTON_NAME) >= 0) {
                    this.tabPressed(this.tabPanelName);
                } else if (elementName.indexOf(PING_BUTTON_NAME) >= 0) {
                    this.ping(utm);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- NetDiagInfoBean.panelAction()");
    }

    public ColumnDescriptor[] getInfoTableRowStructure() {
        return this.m_cdInfoTableStructure;
    }

    public int getInfoTableRowStatus() {
        return 3;
    }

    public int getInfoTableRowCount() {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.getInfoTableRowCount(), count is " + this.m_idInfoTable.length);
        return this.m_idInfoTable.length;
    }

    public ItemDescriptor[] getInfoTableRowAt(int index) {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.getInfoTableRowAt(" + index + ")");
        return new ItemDescriptor[]{this.m_idInfoTable[index]};
    }

    public void setInfoTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getInfoTableSelection() {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.getInfoTableSelection()");
        return this.m_iInfoTableSelection;
    }

    public void setInfoTableSelection(int[] selected) throws IllegalUserDataException {
    }

    public String getSearchEdit() {
        return this.m_sSearchEdit;
    }

    public void setSearchEdit(String s) throws IllegalUserDataException {
        this.m_sSearchEdit = s;
    }

    public String getTcpIpEdit() {
        return this.m_sTcpIpEdit;
    }

    public void setTcpIpEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.setTcpIpEdit(" + s + ")");
        this.m_sTcpIpEdit = s;
    }

    public ColumnDescriptor[] getPingTableRowStructure() {
        return this.m_cdPingTableStructure;
    }

    public int getPingTableRowStatus() {
        return 3;
    }

    public int getPingTableRowCount() {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.getPingTableRowCount(), count is " + this.m_idPingTable.length);
        return this.m_idPingTable.length;
    }

    public ItemDescriptor[] getPingTableRowAt(int index) {
        Trace.trace(TRACE_MASKF, "<> NetDiagInfoBean.getPingTableRowAt(" + index + ")");
        return new ItemDescriptor[]{this.m_idPingTable[index]};
    }

    public void setPingTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
    }

    public int[] getPingTableSelection() {
        return this.m_iPingTableSelection;
    }

    public void setPingTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iPingTableSelection = selected;
    }

    public void load() {
        this.m_idInfoTable = new ItemDescriptor[0];
        this.m_cdInfoTableStructure = new ColumnDescriptor[0];
        this.m_iInfoTableSelection = new int[0];
        this.m_sSearchEdit = "";
        this.m_sTcpIpEdit = "";
        this.m_idPingTable = new ItemDescriptor[0];
        this.m_cdPingTableStructure = new ColumnDescriptor[0];
        this.m_iPingTableSelection = new int[0];
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void prepare() {
        if (!this.showNativeConnectionsPanel) {
            this.getUserTaskManager().setShown("NativeConnectionsPanel", false);
        }
    }

    void setShowNativeConnectionsPanel(boolean b) {
        this.showNativeConnectionsPanel = b;
    }
}

